/*
 * Decompiled with CFR 0.152.
 */
package shadowmaster435.impactfulweather.client.util;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import shadowmaster435.impactfulweather.config.ClientConfig;
import shadowmaster435.impactfulweather.core.init.RegistryReference;
import shadowmaster435.impactfulweather.init.ModRegistry;

public class ParticleEngine {
    public static int netherweathertimer = 0;
    public static boolean netherexperiencingweather = true;

    public static void netherweatherlogic() {
        if (!Minecraft.m_91087_().m_91104_()) {
            if (netherweathertimer == 0) {
                netherexperiencingweather = !netherexperiencingweather;
                netherweathertimer = (Integer)ClientConfig.INSTANCE.misc.nweatherbasedelay.get() * 20 + (int)(Math.abs(Math.random()) * (double)((Integer)ClientConfig.INSTANCE.misc.nweatherrandomdelay.get()).intValue() * 20.0);
            }
            if (netherweathertimer > 0) {
                --netherweathertimer;
            }
        }
    }

    public static void tick() {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            if (level.m_46472_() == Level.f_46428_) {
                if (level.m_46471_() || level.m_46470_()) {
                    ParticleEngine.rain();
                    ParticleEngine.snow();
                    ParticleEngine.desert();
                    ParticleEngine.wind();
                }
                if (level.m_46468_() > 13000L && level.m_46468_() < 23000L) {
                    ParticleEngine.fireflies();
                }
            }
            if (level.m_46472_() == Level.f_46429_) {
                ParticleEngine.nether();
            }
        }
    }

    public static void rain() {
        RegistryReference<SimpleParticleType> rain_type = ModRegistry.RAIN;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player != null && level != null) {
            Biome biome = ParticleEngine.get_biome_at_player((Player)player);
            Vec3 pos = player.m_20182_();
            if (biome.m_264473_() && biome.m_198906_(player.m_20183_())) {
                if ((double)biome.m_47554_() > 0.9 || level.m_46470_()) {
                    rain_type = ModRegistry.HEAVYRAIN;
                    ParticleEngine.spawn_around_player(32.0, pos.f_82480_ + 100.0, -32.0, 96.0, pos.f_82480_ + 100.0, 32.0, 10, rain_type);
                } else {
                    ParticleEngine.spawn_around_player(-32.0, pos.f_82480_ + 100.0, -32.0, 32.0, pos.f_82480_ + 100.0, 32.0, 10, rain_type);
                }
            }
        }
    }

    public static void snow() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player != null && level != null) {
            Biome biome = ParticleEngine.get_biome_at_player((Player)player);
            Vec3 pos = player.m_20182_();
            if (biome.m_264473_() && biome.m_198904_(player.m_20183_())) {
                if (level.m_46470_()) {
                    ParticleEngine.spawn_around_player_in_height_range(-96.0, 32.0, -48.0, 0.0, 32.0, 48.0, 64, 128, 40, ModRegistry.BLIZZARDSNOW);
                    ParticleEngine.spawn_around_player_in_height_range(-32.0, 32.0, -32.0, 32.0, 32.0, 32.0, 64, 256, 10, ModRegistry.BLIZZARDWIND);
                } else {
                    ParticleEngine.spawn_around_player(-32.0, pos.f_82480_ + 100.0, -32.0, 32.0, pos.f_82480_ + 100.0, 32.0, 10, ModRegistry.SNOW);
                }
            }
        }
    }

    public static void desert() {
        Holder<Biome> biome;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        RegistryReference<SimpleParticleType> sand_type = ModRegistry.SANDMOTE;
        if (player != null && level != null && ((biome = ParticleEngine.get_biome_entry_at_player((Player)player)).m_203565_(Biomes.f_48159_) || biome.m_203565_(Biomes.f_48194_) || biome.m_203565_(Biomes.f_186753_) || biome.m_203565_(Biomes.f_48203_))) {
            if (!biome.m_203565_(Biomes.f_48203_)) {
                sand_type = ModRegistry.REDSANDMOTE;
            }
            if (Math.random() < 0.125) {
                ParticleEngine.spawn_around_player_heightmap(-64.0, 1.0, -64.0, 1.0, 3.0, 0.0, 1.0, ModRegistry.TUMBLEBUSH);
            }
            ParticleEngine.spawn_around_player_in_height_range(-32.0, -32.0, -32.0, 32.0, 32.0, 32.0, 64, 96, 24, sand_type);
        }
    }

    public static void wind() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player != null && level != null && !((Biome)level.m_204166_(player.m_20183_()).m_203334_()).m_264473_()) {
            ParticleEngine.spawn_around_player_in_height_range(-32.0, -32.0, -32.0, 32.0, 32.0, 32.0, 64, 192, 20, ModRegistry.GUST);
        }
    }

    public static void fireflies() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player != null && level != null && ParticleEngine.get_biome_entry_at_player((Player)player).m_203565_(Biomes.f_220595_)) {
            ParticleEngine.spawn_around_player_in_height_range(-32.0, -32.0, -32.0, 32.0, 32.0, 32.0, 64, 96, 1, ModRegistry.FIREFLY);
        }
    }

    public static void nether() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (player != null && level != null) {
            Holder biome = level.m_204166_(player.m_20183_());
            if (biome.m_203565_(Biomes.f_48200_)) {
                ArrayList<BlockPos> pos_arr = ParticleEngine.get_random_matching_block_array_around_player(-16.0, -8.0, -16.0, 16.0, 32.0, 16.0, Blocks.f_50451_, 256, (Player)player);
                for (BlockPos pos : pos_arr) {
                    if (level.m_8055_(pos.m_7495_()).m_280555_()) continue;
                    ParticleEngine.spawn_in_area(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_() + 1, pos.m_123342_(), pos.m_123343_() + 1, -1, ModRegistry.WEEPINGTEAR);
                }
            } else if (biome.m_203565_(Biomes.f_48199_)) {
                ArrayList<BlockPos> sand_pos_arr = ParticleEngine.get_random_matching_block_array_around_player(-32.0, -12.0, -32.0, 32.0, 12.0, 32.0, Blocks.f_50135_, 32, (Player)player);
                ArrayList<BlockPos> pos_arr = ParticleEngine.get_random_matching_block_array_around_player(-32.0, -12.0, -32.0, 32.0, 12.0, 32.0, Blocks.f_50136_, 256, (Player)player);
                pos_arr.addAll(sand_pos_arr);
                for (BlockPos pos : pos_arr) {
                    if (level.m_8055_(pos.m_7494_()).m_280555_()) continue;
                    ParticleEngine.spawn_in_area(pos.m_123341_(), (double)pos.m_123342_() - 0.05, pos.m_123343_(), pos.m_123341_() + 8, (double)pos.m_123342_() - 0.05, pos.m_123343_() + 8, -1, ModRegistry.STORMSOUL);
                }
            } else if (biome.m_203565_(Biomes.f_48201_)) {
                ParticleEngine.spawn_around_player_with_air(-32.0, -32.0, -32.0, 32.0, 32.0, 32.0, 32, ModRegistry.WARPEDSPORE);
            } else {
                ParticleEngine.spawn_around_player_with_air(-32.0, -32.0, -32.0, 32.0, 32.0, 32.0, 32, ModRegistry.UPDRAFT);
            }
        }
    }

    public static double get_modifier(RegistryReference<SimpleParticleType> particle) {
        ClientConfig.ParticleTogglesConfig toggle = ClientConfig.INSTANCE.particleToggles;
        ClientConfig.ParticleAmountsConfig amount = ClientConfig.INSTANCE.particleAmounts;
        String val = particle.get().m_5942_().replace("impactfulweather:", "");
        double result = 0.0;
        switch (val) {
            case "sandmote": {
                if (((Boolean)toggle.sandmote.get()).booleanValue()) {
                    result = (Double)amount.sandmotemodifier.get();
                }
            }
            case "redsandmote": {
                if (((Boolean)toggle.redsandmote.get()).booleanValue()) {
                    result = (Double)amount.sandmotemodifier.get();
                }
            }
            case "rain": {
                if (((Boolean)toggle.rain.get()).booleanValue()) {
                    result = (Double)amount.rainmodifier.get();
                }
            }
            case "heavyrain": {
                if (((Boolean)toggle.heavyrain.get()).booleanValue()) {
                    result = (Double)amount.heavyrainmodifier.get();
                }
            }
            case "tumblebush": {
                if (((Boolean)toggle.tumblebush.get()).booleanValue()) {
                    result = (Double)amount.tumblebushmodifier.get();
                }
            }
            case "snow": {
                if (((Boolean)toggle.snow.get()).booleanValue()) {
                    result = (Double)amount.snowmodifier.get();
                }
            }
            case "blizzardsnow": {
                if (((Boolean)toggle.blizzardsnow.get()).booleanValue()) {
                    result = (Double)amount.blizzardsnowmodifier.get();
                }
            }
            case "blizzardwind": {
                if (((Boolean)toggle.blizzardwind.get()).booleanValue()) {
                    result = (Double)amount.blizzardwindmodifier.get();
                }
            }
            case "gust": {
                if (((Boolean)toggle.wind.get()).booleanValue()) {
                    result = (Double)amount.windmodifier.get();
                }
            }
            case "firefly": {
                if (((Boolean)toggle.fireflies.get()).booleanValue()) {
                    result = (Double)amount.fireflymodifier.get();
                }
            }
            case "weepingtear": {
                if (((Boolean)toggle.weepingrain.get()).booleanValue()) {
                    result = (Double)amount.tearmodifier.get();
                }
            }
            case "warpedspore": {
                if (((Boolean)toggle.sporestorm.get()).booleanValue()) {
                    result = (Double)amount.sporemodifier.get();
                }
            }
            case "updraft": {
                if (((Boolean)toggle.updrafts.get()).booleanValue()) {
                    result = (Double)amount.updraftmodifier.get();
                }
            }
            case "stormsoul": {
                if (!((Boolean)toggle.soulstorms.get()).booleanValue()) break;
                result = (Double)amount.soulmodifier.get();
            }
        }
        return result;
    }

    public static Biome get_biome_at(BlockPos pos) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        assert (world != null);
        return (Biome)world.m_204166_(pos).m_203334_();
    }

    public static Biome get_biome_at_player(Player player) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        assert (world != null);
        return (Biome)world.m_204166_(player.m_20183_()).m_203334_();
    }

    public static Holder<Biome> get_biome_entry_at_player(Player player) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        assert (world != null);
        return world.m_204166_(player.m_20183_());
    }

    public static ArrayList<BlockPos> get_random_matching_block_array_around_player(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, Block block, int tries, Player player) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (int i = 0; i < tries; ++i) {
                int randz;
                int randy;
                int randx = (int)Math.round(Mth.m_14139_((double)Math.abs(Math.random()), (double)min_x, (double)max_x)) + player.m_20183_().m_123341_();
                BlockPos rand_pos = new BlockPos(randx, randy = (int)Math.round(Mth.m_14139_((double)Math.abs(Math.random()), (double)min_y, (double)max_y)) + player.m_20183_().m_123342_(), randz = (int)Math.round(Mth.m_14139_((double)Math.abs(Math.random()), (double)min_z, (double)max_z)) + player.m_20183_().m_123343_());
                if (!level.m_8055_(rand_pos).m_60713_(block)) continue;
                result.add(rand_pos);
            }
        }
        return result;
    }

    public static ArrayList<BlockPos> get_random_matching_block_array(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, Block block, int tries) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (int i = 0; i < tries; ++i) {
                int randz;
                int randy;
                int randx = (int)Math.round(Mth.m_14139_((double)Math.abs(Math.random()), (double)min_x, (double)max_x));
                BlockPos rand_pos = new BlockPos(randx, randy = (int)Math.round(Mth.m_14139_((double)Math.abs(Math.random()), (double)min_y, (double)max_y)), randz = (int)Math.round(Mth.m_14139_((double)Math.abs(Math.random()), (double)min_z, (double)max_z)));
                if (!level.m_8055_(rand_pos).m_60713_(block)) continue;
                result.add(rand_pos);
            }
        }
        return result;
    }

    public static int modified_try_count(double initial, RegistryReference<SimpleParticleType> particle) {
        double particle_modifier = ParticleEngine.get_modifier(particle);
        if (particle_modifier > 0.0) {
            return (int)Math.round(initial + ((Double)ClientConfig.INSTANCE.particleAmounts.particleDensity.get() + ParticleEngine.get_modifier(particle)));
        }
        return 0;
    }

    public static void spawn_in_area_heightmap(double min_x, double min_y_offset, double min_z, double max_x, double max_y_offset, double max_z, int amount, RegistryReference<SimpleParticleType> particle) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (int i = 0; i < ParticleEngine.modified_try_count(amount, particle); ++i) {
                double randx = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_x, (double)max_x);
                double randz = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_z, (double)max_z);
                double height = level.m_6924_(Heightmap.Types.WORLD_SURFACE, (int)Math.round(randx), (int)Math.round(randz));
                double randy = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_y_offset, (double)max_y_offset) + height;
                BlockPos pos = new BlockPos((int)randx, (int)randy, (int)randz);
                level.m_7106_((ParticleOptions)particle.get(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawn_at_provided(ArrayList<BlockPos> positions, int amount, RegistryReference<SimpleParticleType> particle) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (int i = 0; i < ParticleEngine.modified_try_count(amount, particle); ++i) {
                BlockPos pos = positions.get((int)Math.round(Math.abs(Math.random()) * (double)positions.size()));
                level.m_7106_((ParticleOptions)particle.get(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawn_at(BlockPos pos, RegistryReference<SimpleParticleType> particle) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            level.m_7106_((ParticleOptions)particle.get(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.0, 0.0, 0.0);
        }
    }

    public static void spawn_around_player_in_height_range(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, int min_height, int max_height, int amount, RegistryReference<SimpleParticleType> particle) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Vec3 min = player.m_20182_().m_82520_(min_x, 0.0, min_z);
            Vec3 max = player.m_20182_().m_82520_(max_x, 0.0, max_z);
            ParticleEngine.spawn_in_area_in_height_range(min.f_82479_, min_height, min.f_82481_, max.f_82479_, max_height, max.f_82481_, min_height, max_height, ParticleEngine.modified_try_count(amount, particle), particle);
        }
    }

    public static void spawn_around_player_with_air(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, int amount, RegistryReference<SimpleParticleType> particle) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Vec3 min = player.m_20182_().m_82520_(min_x, min_y, min_z);
            Vec3 max = player.m_20182_().m_82520_(max_x, max_y, max_z);
            ParticleEngine.spawn_in_area_with_air(min.f_82479_, min.f_82480_, min.f_82481_, max.f_82479_, max.f_82480_, max.f_82481_, ParticleEngine.modified_try_count(amount, particle), particle);
        }
    }

    public static void spawn_around_player_heightmap(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, double amount, RegistryReference<SimpleParticleType> particle) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Vec3 min = player.m_20182_().m_82520_(min_x, 0.0, min_z);
            Vec3 max = player.m_20182_().m_82520_(max_x, 0.0, max_z);
            ParticleEngine.spawn_in_area_heightmap(min.f_82479_, min_y, min.f_82481_, max.f_82479_, max_y, max.f_82481_, ParticleEngine.modified_try_count(amount, particle), particle);
        }
    }

    public static void spawn_around_player(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, int amount, RegistryReference<SimpleParticleType> particle) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Vec3 min = player.m_20182_().m_82520_(min_x, min_y, min_z);
            Vec3 max = player.m_20182_().m_82520_(max_x, max_y, max_z);
            ParticleEngine.spawn_in_area(min.f_82479_, min.f_82480_, min.f_82481_, max.f_82479_, max.f_82480_, max.f_82481_, ParticleEngine.modified_try_count(amount, particle), particle);
        }
    }

    public static void spawn_in_area_in_height_range(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, int min_height, int max_height, int amount, RegistryReference<SimpleParticleType> particle) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (int i = 0; i < ParticleEngine.modified_try_count(amount, particle); ++i) {
                boolean in_height_range;
                double randx = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_x, (double)max_x);
                double randy = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_y, (double)max_y);
                double randz = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_z, (double)max_z);
                boolean is_air = !level.m_8055_(new BlockPos(new Vec3i((int)Math.round(randx), (int)Math.round(randy), (int)Math.round(randz)))).m_280555_();
                boolean bl = in_height_range = randy >= (double)min_height && randy <= (double)max_height;
                if (!is_air || !in_height_range) continue;
                level.m_7106_((ParticleOptions)particle.get(), randx, randy, randz, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawn_in_area_with_air(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, int amount, RegistryReference<SimpleParticleType> particle) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (int i = 0; i < ParticleEngine.modified_try_count(amount, particle); ++i) {
                double randx = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_x, (double)max_x);
                double randy = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_y, (double)max_y);
                double randz = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_z, (double)max_z);
                if (level.m_8055_(new BlockPos(new Vec3i((int)Math.round(randx), (int)Math.round(randy), (int)Math.round(randz)))).m_280555_() || !level.m_6425_(new BlockPos(new Vec3i((int)Math.round(randx), (int)Math.round(randy), (int)Math.round(randz)))).m_76178_()) continue;
                level.m_7106_((ParticleOptions)particle.get(), randx, randy, randz, 0.0, 0.0, 0.0);
            }
        }
    }

    public static void spawn_in_area(double min_x, double min_y, double min_z, double max_x, double max_y, double max_z, int amount, RegistryReference<SimpleParticleType> particle) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (int i = 0; i < ParticleEngine.modified_try_count(amount, particle); ++i) {
                double randx = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_x, (double)max_x);
                double randy = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_y, (double)max_y);
                double randz = Mth.m_14139_((double)Math.abs(Math.random()), (double)min_z, (double)max_z);
                level.m_7106_((ParticleOptions)particle.get(), randx, randy, randz, 0.0, 0.0, 0.0);
            }
        }
    }
}

